*** 
*** Code for "The Labor Market Integration of Refugee Migrants in High-Income Countries"
*** Courtney Brell, Christian Dustmann, and Ian Preston
***
*** Analysis of the UK Labour Force Survey's 2008 Ad-hoc module
*** This file should be run in the folder containing the UK LFS 2008 ad-hoc module data
***

********************************************************************************
*** Preliminaries

clear all

* Import data
use "stata8\uk2008_adhoc.dta", clear

* Generate demographic variables
gen countryoforigin=countryb
gen female = .
replace female=1 if sex=="2"
replace female=0 if sex=="1"
rename age age_cat

* Calculate the number of years since arrival
gen yearofinterview=year
gen yearssincearrive=yearesid
drop if (!inlist(yearesid,"00","01","02","03","04","05","06","07","08"))&(!inlist(yearesid,"09","10"))
destring yearssincearrive, replace

* Identify migrant types
gen native=(yearesid=="00")
gen refugee=(ahm2008_migreas=="5"&countryoforigin!="00")
gen immigrant=(countryoforigin=="01"&native!=1&refugee!=1)
gen migranttype=0 if native==1
replace migranttype=1 if refugee==1
replace migranttype=2 if immigrant==1
label define Lmigrant 0 "Native" 1 "Refugee" 2 "Other immigrant"
label values migranttype Lmigrant
* Drop refugees from this sample
drop if refugee==1

* Choose our sample
drop if missing(migranttype)
keep if age_cat>=22&age_cat<=62
* Use survey weights
gen indweight=coeff

********************************************************************************
*** Calculate employment outcomes (no wage data available)

* Employment
gen employment=(wstator=="1"|wstator=="2")
gen Nemp=!missing(employment)

preserve
collapse (mean) employment (rawsum) Nemp [aw=indweight], by(female yearssincearrive migranttype)
save "UK-LFS", replace
restore
preserve
collapse (mean) employment (rawsum) Nemp [aw=indweight], by(yearssincearrive migranttype)
append using "UK-LFS"
order yearssincearrive migranttype female employment Nemp
sort migranttype female yearssincearrive
save "UK-LFS", replace
restore

********************************************************************************
*** Calculate sample descriptives

forval loopmig=0(2)2{
preserve
	disp `loopmig'
	keep if yearssincearrive<=10
	keep if migranttype==`loopmig'

	* # Observations
	count

	* Gender
	sum female [aw=indweight]
	* Age
	sum age_cat [aw=indweight], detail
		
	* Time since arrival
	sum yearssincearrive [aw=indweight], detail

	* Age at arrival
	gen age_at_arrival=age_cat-yearssincearrive
	sum age_at_arrival [aw=indweight], detail

	* Year of arrival
	gen year_of_arrival=2008-yearssincearrive
	sum year_of_arrival [aw=indweight], detail

	* LM outcomes
	count if !missing(employment)
	sum employment [aw=indweight], detail
restore
}

********************************************************************************
*** Clean up

clear all
